/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jaudiotagger.audio.generic.AbstractTag;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.images.Artwork;

public abstract class GenericTag
extends AbstractTag {
    private static EnumSet<FieldKey> supportedKeys = EnumSet.of(FieldKey.ALBUM, new FieldKey[]{FieldKey.ARTIST, FieldKey.TITLE, FieldKey.TRACK, FieldKey.GENRE, FieldKey.COMMENT, FieldKey.YEAR});

    @Override
    protected boolean isAllowedEncoding(String enc) {
        return true;
    }

    @Override
    public TagField createField(FieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (supportedKeys.contains((Object)genericKey)) {
            return new GenericTagTextField(genericKey.name(), value);
        }
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    @Override
    public String getFirst(FieldKey genericKey) throws KeyNotFoundException {
        return this.getValue(genericKey, 0);
    }

    @Override
    public String getValue(FieldKey genericKey, int index) throws KeyNotFoundException {
        if (supportedKeys.contains((Object)genericKey)) {
            return this.getItem(genericKey.name(), index);
        }
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    @Override
    public List<TagField> getFields(FieldKey genericKey) throws KeyNotFoundException {
        List list = (List)this.fields.get(genericKey.name());
        if (list == null) {
            return new ArrayList<TagField>();
        }
        return list;
    }

    @Override
    public List<String> getAll(FieldKey genericKey) throws KeyNotFoundException {
        return super.getAll(genericKey.name());
    }

    @Override
    public void deleteField(FieldKey genericKey) throws KeyNotFoundException {
        if (!supportedKeys.contains((Object)genericKey)) {
            throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
        }
        this.deleteField(genericKey.name());
    }

    @Override
    public TagField getFirstField(FieldKey genericKey) throws KeyNotFoundException {
        if (supportedKeys.contains((Object)genericKey)) {
            return this.getFirstField(genericKey.name());
        }
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    @Override
    public List<Artwork> getArtworkList() {
        return Collections.emptyList();
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    private class GenericTagTextField
    implements TagTextField {
        private String content;
        private final String id;

        public GenericTagTextField(String fieldId, String initialContent) {
            this.id = fieldId;
            this.content = initialContent;
        }

        @Override
        public void copyContent(TagField field) {
            if (field instanceof TagTextField) {
                this.content = ((TagTextField)field).getContent();
            }
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public String getEncoding() {
            return "ISO-8859-1";
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public byte[] getRawContent() {
            return this.content == null ? new byte[]{} : Utils.getDefaultBytes(this.content, this.getEncoding());
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        @Override
        public void isBinary(boolean b) {
        }

        @Override
        public boolean isCommon() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.content.equals("");
        }

        @Override
        public void setContent(String s) {
            this.content = s;
        }

        @Override
        public void setEncoding(String s) {
        }

        @Override
        public String toString() {
            return this.getContent();
        }
    }
}

